-- Let's set up some common colors.
NeonColor = {
	Red		= color("#ff0000"),	-- red
	Gold	= color("#ffcc00"),	-- not quite the same as LocalGoldColor
	Yellow	= color("#ffff00"),	-- bright yellow
	Green	= color("#00ff00"),	-- pure green
	Teal	= color("#00ff99"),	-- well... teal
	Cyan	= color("#00ffff"),	-- pure cyan
	Blue	= color("#0000ff"),	-- pure blue
	Purple	= color("#9900ff"),	-- purple...
	Pink	= color("#ff00ff"),	-- pure magenta
}

-- The main blue. "blend" is a float between 0 and 1;
-- 0 for a very dark tone, 1 for a nice bright blue.
function LocalBlueColor(blend)
	if not blend then local blend = 1 end
	return lerp_color(blend, color("#001523"), color("#009cff"))
end

-- Gold for accent, works the same as the last function.
function LocalGoldColor(blend)
	if not blend then local blend = 1 end
	return lerp_color(blend, color("#240c00"), color("#ffc000"))
	--#241100
end

-- Lame shorthand
function ColorBlend(c1, c2)
	return lerp_color(0.5, c1, c2)
end

--
GameColor = {
	PlayerColors = {
		PLAYER_1 = ColorBlend(NeonColor.Cyan,NeonColor.Blue),
		PLAYER_2 = ColorBlend(NeonColor.Green,NeonColor.Teal),
	},

	Difficulty = {
		Beginner	= NeonColor.Teal,			-- ParaPara: kinda between cyan and green
		Easy		= NeonColor.Green,			-- ParaPara+: pure green
		Medium		= NeonColor.Cyan,			-- Freestyle Normal: cyan, woulda been blue but
		Hard		= NeonColor.Purple,			-- Freestyle Hard: purple
		Challenge	= NeonColor.Pink,			-- Freestyle Expert: magenta
		Edit		= color("0.8,0.8,0.8,1"),	-- (my favorite paint colors: Titanium White, Burnt Sienna,) Edit Gray
	},
	
	DiffAppend = {
		freestyleanother = NeonColor.Red,		-- Freestyle Another: pure red
		--[[should find a better way to implement these
		beginner		 = NeonColor.Cyan,		-- Beginner (DDR): cyan
		basic			 = NeonColor.Yellow,	-- Basic (DDR): yellow
		difficult		 = NeonColor.Red,		-- Difficult (DDR): red
		expert			 = NeonColor.Green,		-- Expert (DDR): green. No Challenge 'cause it's the same as default Challenge color
		--]]
	},
	
	StepsType = {
		Single		= NeonColor.Gold,
		Double		= NeonColor.Green,
		Couple		= NeonColor.Purple,
		Routine		= NeonColor.Cyan,
	},

	Judgment = {
		W1		=	NeonColor.Gold,	-- gold-ish
		W2		=	NeonColor.Green,	-- pure green
		W3		=	NeonColor.Cyan,	-- pure cyan
		W4		=	LoadModule("Gameplay.AutoJudgeGraphics.lua")() == "fivejudg" and NeonColor.Pink or NeonColor.Blue,	-- HAX
		W5		=	NeonColor.Pink,	-- pure magenta
		Miss	=	NeonColor.Red,	-- red
		Held	=	color("#FFFFFF"),	-- lol
		Holds	=	color("#FFFFFF"), -- LULW
		LetGo	=	color("#ff3c3c"),
		MaxCombo	=	color("#FFFFFF")
	},
	
	Grade = {
		Tier01 = Color.Black,		-- SSS, should be rendered as rainbow
		Tier02 = NeonColor.Yellow,	-- SS, yellow
		Tier03 = NeonColor.Gold,	-- S, orange/gold
		Tier04 = NeonColor.Green,	-- A, green
		Tier05 = NeonColor.Cyan,	-- B, cyan
		Tier06 = NeonColor.Blue,	-- C, blue
		Tier07 = NeonColor.Purple,	-- D, purple
		Tier08 = NeonColor.Pink,	-- E, magenta
		Failed = NeonColor.Red,		-- F, red
		None =	Color.Stealth
	},

	HealthState = {
		Hot		=	color("#ffddaa"),	-- doesn't actually matter because we render it as rainbow
		Alive	=	NeonColor.Green,	-- pure green
		Danger	=	NeonColor.Red,	-- red
		Dead	=	NeonColor.Red,	-- red again; shouldn't matter because no gauge visible anyway?
		UnderPassmark	=	NeonColor.Blue,	-- pure blue; this isn't a real HealthState, but
	},

	Mode = {
		Parapara	=	NeonColor.Green,	-- pure green
		Freestyle	=	NeonColor.Cyan,	-- gold-ish
		Nonstop		=	NeonColor.Pink,	-- pure magenta
		Normal		=	NeonColor.Green,	-- pure green... again
	}
}

-- And now... the REDIR BLOCK (which is somehow still necessary...)
GameColor.Difficulty["Difficulty_Beginner"] = GameColor.Difficulty["Beginner"]
GameColor.Difficulty["Difficulty_Easy"] = GameColor.Difficulty["Easy"]
GameColor.Difficulty["Difficulty_Medium"] = GameColor.Difficulty["Medium"]
GameColor.Difficulty["Difficulty_Hard"] = GameColor.Difficulty["Hard"]
GameColor.Difficulty["Difficulty_Challenge"] = GameColor.Difficulty["Challenge"]
GameColor.Difficulty["Difficulty_Edit"] = GameColor.Difficulty["Edit"]

-- Check the chart name against a certain table to see if another extra color can be used first.
local function GameColorDifficultyWrapper(diff, chartMName)
	if chartMName ~= "" and GameColor.DiffAppend[chartMName] then
		return GameColor.DiffAppend[chartMName]
	end
	assert(GameColor.Difficulty[diff], "GameColor:  There is no entry in GameColor.Difficulty for CustomDifficulty '" .. tostring(diff) .. "'.")
	return GameColor.Difficulty[diff]
end

function CustomDifficultyToColor( sCustomDifficulty, chartName )
	return GameColorDifficultyWrapper(sCustomDifficulty, chartName and string.lower(string.gsub(chartName, "%A", "")) or "")
end

-- Copied from _fallback because I swear these were acting up when they weren't copied here
function JudgmentToColor( i )
	if not GameColor or not GameColor.Judgment then return Color.Black end
	return GameColor.Judgment[ToEnumShortString(i)] or Color.Black
end

function GameModeToColor(i)
	if not GameColor or not GameColor.Mode then return Color.Black end
	return GameColor.Mode[i] or Color.Black
end

function GradeTierToColor(g)
	if not GameColor or not GameColor.Grade then return Color.Black end
	return GameColor.Grade[ToEnumShortString(g)] or Color.Black
end
